function [a]=sens_plotS(ip,dsr,n,nds,dummy);
%function [a]=sens_plotS(ip,dsr,n,nds,dummy);
% Ian Stothers may  2022

if (nargin==5)
    sens_plotSS(ip,dsr,n,nds);
    return
end

  if (nargin<4)  dsr=100;   end
  if (nargin<3)  n=10000;   end
  if (nargin<2)  nds=1000;  end
  if (nargin<1)  ip='192.168.1.4';  end
  if (ischar(ip)==0) ip=ip.ip; endif


callstr1= ["sens_plotS("...
 sprintf("'\%s\',",ip)...
 sprintf("%d,",dsr)...
 sprintf("%d,",n)...
 sprintf("%d,0);",nds)...
 ];

octave_spawn(callstr1);

endfunction

function [a]=sens_plotSS(ip,dsr,n,nds);
%function [a]=sens_plotSS(skt,dsr,n,nds);
% Ian Stothers may  2022
  if (ischar(ip)) skt=sktopen(ip); end
  fbw=1/dsr;
  if ((exist('butter')~=3))
   pkg load signal
  end
  [bb,aa]=butter(3,fbw/2);
  sr=1000.0; %sample rate
  sp=1/sr;
  ds_sp=sp*dsr;  %down sample sample rate

sinlength=10000.0/32768.0;
[a,ptr]=GetSensData1(skt,2);
[a,ptr]=GetSensData1(skt,ptr);

  idx=find(a>32767.0);
  msa=max(size(a));
  a(idx)=a(idx)-65536;
  a=a*sinlength;

pos=mean(a)*ones(1,n);
[fpos,sf]=filter(bb,aa,pos);
ppos=[ pos' fpos'];

 sff=figure ("toolbar", "none");
 set(sff,'renderermode','manual');
 set(sff,"numbertitle","off");
 set(sff,'name',['CIC Sensor Plot IP - ' skt.ip]);


snum=1:max(size(pos));
t=(snum-1)'*sp;
numsamps=max(snum);
ph=subplot(211);
phdl=plot(t,ppos);
pahdl=get(phdl(1),'parent');
s=sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)));
s=[s sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)))];
ylabel('um');
xlabel('Time (Secs)');
thdl=title(s);
grid on;
drawnow;

ds_pos=(mean(pos)*ones(1,nds));
ds_snum=1:max(size(ds_pos));
ds_t=((ds_snum-1)'*ds_sp)';

subplot(212);
ds_phdl=plot(ds_t,ds_pos);
ds_s=sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(ds_pos),sqrt(var(ds_pos)));
ylabel('um');
xlabel('Time (Secs)');
ds_thdl=title(ds_s);
grid on;
drawnow;
ds_pahdl=get(ds_phdl,'parent');
try
 while (1)
  [a,ptr]=GetSensData1(skt,ptr);
  msa=size(a)(2);
  if (msa>0)
   idx=find(a>32767.0);
   a(idx)=a(idx)-65536;
   a=a*sinlength;
   [fa,sf]=filter(bb,aa,a,sf);
   pos=[pos((msa+1):end) a];
   msfa=size(fa)(2);
   if(msfa>0)
    fpos=[fpos((msfa+1):end) fa];
    idx=(1:msfa)+numsamps;
    numsamps=numsamps+msfa;
    idx=find(rem(idx,dsr)==0);
    if (min(size(idx))>0)
     ds_a=fa(idx);
     ds_pos=[(ds_pos((size(ds_a)(2)+1):end)) ds_a];
     RESB=udpget(skt,'RESB');
     ds_s=sprintf('mean pos= %2.4fum  rms=%2.4fum   Signal Strength=%5.0f',mean(ds_pos),sqrt(var(ds_pos)),RESB);
     set(ds_thdl,'string',ds_s);
     mindp=min(ds_pos);
     maxdp=max(ds_pos);
     if (mindp>=maxdp)
       maxdp=mindp+1;
     end
     ylim(ds_pahdl,[mindp maxdp]);
     set(ds_phdl,'ydata',ds_pos);
    end
   end
   s=sprintf('un-filtered mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)));
   s=[s sprintf('       filtered mean pos= %2.4fum  rms=%2.4fum',mean(fpos),sqrt(var(fpos)))];
   set(thdl,'string',s);
   minp=min(pos);
   maxp=max(pos);
   if (minp>=maxp)
     maxp=minp+1;
   end
   ylim(pahdl,[minp maxp]);
   set(phdl(1),'ydata',pos');
   set(phdl(2),'ydata',fpos');
   drawnow;
   pause(0.1)
  end
 end
catch
end
endfunction

function [d,np]=GetSensData1(skt,op)
  %get new data
  nd=udpget(skt,'Sens_Fifo');
  np=nd(1);
  nd=nd(2:end);
  snd=max(size(nd));
  d=[];
  if(np<op)
   d=nd(op:snd);
   op=1;
  end
  if (np>op)
    d=[d nd(op:(np-1))];
    op=np;
  end
endfunction

